# 画面設計書 278-OAuth リダイレクト

## 概要

本ドキュメントは、GitLabの「Web IDE OAuth リダイレクト」画面の設計書です。Web IDEがOAuth認証を完了した後のコールバック処理を行う画面の仕様を記載しています。

### 本画面の処理概要

**業務上の目的・背景**：Web IDEは、GitLab APIへのアクセスにOAuth認証を使用します。ユーザーがWeb IDEを使用する際、GitLab APIへのアクセス権限を付与するためのOAuth認証フローが発生します。この画面は、OAuth認証プロバイダからのコールバックを受け取り、Web IDEに認証トークンを渡すための中間ページとして機能します。

**画面へのアクセス方法**：Web IDEのOAuth認証フローで、認証プロバイダ（GitLab OAuth）から自動的にリダイレクトされます。直接アクセスすることは想定されていません。

**主要な操作・処理内容**：
1. OAuth認証コールバックの受信
2. 認証トークンの取得
3. Web IDEへのトークン転送
4. 認証完了後のWeb IDE画面への復帰

**画面遷移**：OAuth認証プロバイダからリダイレクトで到達。処理完了後、Web IDE本体画面に戻ります。

**権限による表示制御**：OAuth認証フローの一部として機能するため、認証中のユーザーのみがアクセスします。OAuthアプリケーションが設定されていない場合は404エラーが表示されます。

## 関連機能

| 機能No | 機能名 | 関連種別 | 関連する操作・処理 |
|--------|--------|----------|------------------|
| 88 | OAuth2プロバイダ | 主機能 | Web IDE OAuthリダイレクト処理 |

## 画面種別

処理（リダイレクト）

## URL/ルーティング

```
GET /-/ide/oauth_redirect
```

## 入出力項目

| 項目名 | 入出力 | 型 | 必須 | 説明 |
|--------|--------|-----|------|------|
| code | 入力（URL） | String | - | OAuth認証コード |
| state | 入力（URL） | String | - | CSRF防止用ステート値 |

## 表示項目

| 項目名 | 説明 |
|--------|------|
| ローディング表示 | Authenticating... |

### データ属性（JavaScript用）

| 属性名 | 説明 |
|--------|------|
| client-id | OAuthクライアントID |
| callback-urls | OAuthコールバックURL |

## イベント仕様

### 1-OAuth認証コールバック処理

**トリガー**: OAuth認証プロバイダからのリダイレクト

**処理フロー**:
1. URLパラメータからOAuth認証コードとステートを取得
2. JavaScript側でトークン交換リクエストを発行
3. アクセストークンを取得
4. Web IDE親ウィンドウ/タブにトークンを通知
5. リダイレクトまたはウィンドウクローズ

## データベース更新仕様

### 操作別データベース影響一覧

| 操作（イベント） | 対象テーブル | 操作種別 | 概要 |
|----------------|-------------|---------|------|
| トークン交換 | oauth_access_tokens | INSERT/UPDATE | アクセストークンの発行 |

### テーブル別更新項目詳細

#### oauth_access_tokens

| 操作 | 項目（カラム名） | 更新値・取得条件 | 備考 |
|-----|-----------------|-----------------|------|
| INSERT | token | 生成されたトークン | 暗号化保存 |
| INSERT | application_id | Web IDE OAuthアプリID | |
| INSERT | resource_owner_id | 認証ユーザーID | |
| INSERT | scopes | api等 | |
| INSERT | expires_in | トークン有効期間 | |
| INSERT | created_at | 現在日時 | |

## メッセージ仕様

| メッセージID | 種別 | メッセージ内容 | 表示条件 |
|-------------|------|---------------|---------|
| MSG001 | 情報 | Authenticating... | 認証処理中 |

## 例外処理

| 例外 | 処理内容 |
|------|---------|
| OAuthアプリケーション未設定 | 404エラーページを表示 |
| 認証コード不正 | エラーメッセージを表示 |
| ステート値不一致 | CSRF攻撃とみなしエラー |

## 備考

- `WebIde::DefaultOauthApplication.oauth_application`でOAuthアプリ存在確認
- `minimal: true`オプションでミニマルレイアウトを使用
- `fullscreen`レイアウトで表示
- フロントエンドのJavaScriptで実際のトークン交換処理を実行
- 親ウィンドウ/タブとの通信にpostMessageを使用する可能性あり

---

## コードリーディングガイド

本画面を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

OAuthアプリケーション設定を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | default_oauth_application.rb | `app/models/web_ide/default_oauth_application.rb` | Web IDE用OAuthアプリの管理 |

**読解のコツ**:
- `oauth_application`メソッドでアプリケーションの取得
- `oauth_application_callback_urls`でコールバックURL取得
- `ensure_oauth_application!`で自動作成処理

#### Step 2: エントリーポイントを理解する

コントローラの処理フローを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | ide_controller.rb | `app/controllers/ide_controller.rb` | oauth_redirectアクション（30-37行目） |

**主要処理フロー**:
1. **34行目**: OAuthアプリケーション存在チェック
2. **36行目**: fullscreenレイアウト、minimalオプションでレンダリング

#### Step 3: ビューを理解する

画面構成を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | oauth_redirect.html.haml | `app/views/ide/oauth_redirect.html.haml` | OAuth リダイレクト画面テンプレート |
| 3-2 | ide_helper.rb | `app/helpers/ide_helper.rb` | ide_oauth_dataメソッド（61-71行目） |

**主要処理フロー**:
- **1行目（oauth_redirect）**: ページタイトル設定
- **3行目**: shared/ide_rootパーシャルをレンダリング（Authenticating...メッセージ）

### プログラム呼び出し階層図

```
IdeController#oauth_redirect
    │
    ├─ WebIde::DefaultOauthApplication.oauth_application
    │      └─ 存在チェック（なければ404）
    │
    └─ render layout: 'fullscreen', locals: { minimal: true }
           └─ shared/_ide_root.html.haml
                  └─ ide_oauth_data
                         ├─ client-id
                         └─ callback-urls
```

### データフロー図

```
[入力]                    [処理]                         [出力]

OAuthコールバック ───▶ IdeController#oauth_redirect
(code, state)             │
                          ├─▶ oauth_application存在確認
                          │
                          ├─▶ ide_oauth_data
                          │       │
                          │       ├─▶ client_id
                          │       │
                          │       └─▶ callback_urls
                          │
                          └─▶ render ───▶ JS処理でトークン交換
                                               │
                                               └─▶ Web IDE本体へ
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| ide_controller.rb | `app/controllers/ide_controller.rb` | コントローラ | OAuthリダイレクト処理 |
| ide_helper.rb | `app/helpers/ide_helper.rb` | ヘルパー | OAuthデータ準備 |
| oauth_redirect.html.haml | `app/views/ide/oauth_redirect.html.haml` | ビュー | リダイレクト画面テンプレート |
| default_oauth_application.rb | `app/models/web_ide/default_oauth_application.rb` | モデル | OAuthアプリ管理 |
| _ide_root.html.haml | `app/views/shared/_ide_root.html.haml` | ビュー | Vue.jsマウントポイント |
